package com.afanticar.afantiopenapi.model.vo;

import com.alibaba.fastjson.annotation.JSONType;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

@Data
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class BydXiaoHongShuMemberDayVO {
    @ApiModelProperty(value = "门店名称", example = "南京宁星")
    private Integer storeName;
    @ApiModelProperty(value = "门店编码", example = "ABC123")
    private Integer storeCode;
    @ApiModelProperty(value = "门店ID", example = "200")
    private Integer storeId;
    @ApiModelProperty(value = "门店类型", example = "门店类型1")
    private Integer storeType;
    @ApiModelProperty(value = "大区名称", example = "大区名称1")
    private Integer areaName;
    @ApiModelProperty(value = "大区ID", example = "200")
    private Integer villageName;
    @ApiModelProperty(value = "品牌名称", example = "比亚迪-海洋")
    private Integer principalName;
    @ApiModelProperty(value = "省份名称", example = "广东")
    private Integer provinceName;
    @ApiModelProperty(value = "城市名称", example = "深圳")
    private Integer cityName;

    private List<BydXiaoHongShuMemberDayDetailVO> detailList;

    @Data
    public static class BydXiaoHongShuMemberDayDetailVO {
        @ApiModelProperty(value = "统计日期", example = "2023-03-03")
        private LocalDate statsDate;
        @ApiModelProperty(value = "粉丝数", example = "200")
        private Integer fansCntTotal;
        @ApiModelProperty(value = "粉丝新增数", example = "200")
        private Integer fansCntDi;
        @ApiModelProperty(value = "笔记新增数", example = "200")
        private Integer noteCntDi;
        @ApiModelProperty(value = "笔记点赞新增数", example = "200")
        private Integer noteLikeCntDi;
        @ApiModelProperty(value = "笔记评论新增数", example = "200")
        private Integer noteCommentCntDi;
        @ApiModelProperty(value = "笔记收藏新增数", example = "200")
        private Integer noteFavoriteCntDi;
        @ApiModelProperty(value = "笔记分享新增数", example = "200")
        private Integer noteShareCntDi;
    }
}
