package com.afanticar.afantiopenapi.mapper;

import com.afanticar.afantiopenapi.model.entity.XiaoHongShuMemberDay;
import com.afanticar.afantiopenapi.model.vo.BydXiaoHongShuMemberDayVO;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.time.LocalDate;

@Mapper
@DS("afanti-bi-app")
public interface XiaoHongShuMemberDayMapper extends BaseMapper<XiaoHongShuMemberDay> {


    @Select("select * \n" +
            "from dws_xiaohongshu_member_action_day a  \n" +
            "where 1=1 \n" +
            "and statistics_day >= #{startDate}\n" +
            "and statistics_day <= #{endDate}\n" +
            "and matrix_member_id in (\n" +
            "   select matrix_member_id \n" +
            "   from dim_matrix_member_info \n" +
            "   where principal_id=#{principalId} \n" +
            "   and is_valid=1 \n" +
            "   and end_time ='2099-01-01'" +
            ") \n" +
            "order by statistics_day,a.matrix_member_id"
    )
    Page<XiaoHongShuMemberDay> queryMemberDayByPrincipalId(
            Page page,
            @Param("principalId") String principalId,
            @Param("startDate") LocalDate startDate,
            @Param("endDate") LocalDate endDate
    );
}
