package com.afanticar.afantiopenapi.model.entity;

import com.alibaba.fastjson.annotation.JSONType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

@Data
@TableName("dws_xiaohongshu_member_action_day")
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class XiaoHongShuMemberDay {
    /**
     * 成员id
     */
    private String matrixMemberId;

    /**
     * 获赞与收藏
     */
    private Integer favedCount;

    /**
     * 关注数
     */
    private Integer followingCount;

    /**
     * 粉丝数
     */
    private Integer fansCountTotal;

    /**
     * 本日新增获赞与收藏数
     */
    private Integer favedCountDi;

    /**
     * 本日新增关注数
     */
    private Integer followingCountDi;

    /**
     * 本日新增粉丝数
     */
    private Integer fansCountTotalDi;

    /**
     * 统计日期，YYYY-MM-DD 00:00:00
     */
    private LocalDate statisticsDay;

    /**
     * 数据更新时间
     */
    private LocalDateTime mtime;

    /**
     * 数据创建时间
     */
    private LocalDateTime ctime;

    /**
     * 本日笔记发布数
     */
    private Integer noteCountDi;

    /**
     * 本日笔记新增观看数
     */
    private Integer noteReadCountDi;

    /**
     * 本日笔记新增点赞数
     */
    private Integer noteDiggCountDi;

    /**
     * 本日笔记新增收藏数
     */
    private Integer noteCollectCountDi;

    /**
     * 本日笔记新增评论数
     */
    private Integer noteCommentCountDi;

    /**
     * 本日笔记新增分享数
     */
    private Integer noteShareCountDi;

    /**
     * 本日有发布笔记的主播账号数
     */
    private Integer notePublishAuthorCount;

    /**
     * 是否删除
     */
    private Byte isDeleted;

    /**
     * 0:默认值,1:正常,2:退网
     */
    private Byte status;

    /**
     * 主播数量
     */
    private Integer authorCount;

    /**
     * 总点赞数
     */
    private Integer diggCountTotal;

    /**
     * 本日新增点赞数
     */
    private Integer diggCountDi;

    /**
     * 总收藏数
     */
    private Integer collectCountTotal;

    /**
     * 本日新增收藏数
     */
    private Integer collectCountDi;

    /**
     * 本日总作品数
     */
    private Integer noteCountTotal;

    /**
     * 本日直播总场次
     */
    private Integer liveTotalCount;

    /**
     * 本日直播总点赞数
     */
    private Integer liveTotalLikeCount;

    /**
     * 本日直播总点赞人数
     */
    private Integer liveTotalLikeUserCount;

    /**
     * 本日直播总评论数
     */
    private Integer liveTotalCommentCount;

    /**
     * 本日直播总评论人数
     */
    private Integer liveTotalCommentUserCount;

    /**
     * 本日直播总送礼数
     */
    private Integer liveTotalGiftCount;

    /**
     * 本日直播总送礼人数
     */
    private Integer liveTotalGiftUserCount;

    /**
     * 本日直播总互动数（评论数+点赞数+送礼数）
     */
    private Integer liveTotalPollingCount;

    /**
     * 本日直播总互动人数
     */
    private Integer liveTotalPollingUserCount;

    /**
     * 本日直播总时长
     */
    private Integer liveTotalTime;

    /**
     * 本日直播总新增粉丝数
     */
    private Integer liveTotalFansAdd;

    /**
     * 本日直播总薯钻
     */
    private Integer liveTotalDiamondCount;

    /**
     * 本日直播总观看人数
     */
    private Integer liveTotalWatchUserCount;

    /**
     * 本日直播总观看人次
     */
    private Integer liveTotalWatchUserTime;
}
