package com.afanticar.afantiopenapi.controller;

import com.afanticar.afantiopenapi.model.BaseResponse;
import com.afanticar.afantiopenapi.model.dto.CommonPageInfoDTO;
import com.afanticar.afantiopenapi.model.dto.DataReportRequestDTO;
import com.afanticar.afantiopenapi.model.dto.ReportDataInfoDTO;
import com.afanticar.afantiopenapi.service.DataReportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

/**
 * @author hejincai
 * @since 2025/4/23 16:35
 **/
@Api("阿凡提数据报表接口")
@RestController
@RequestMapping("/info")
@Slf4j
@Validated
public class DataReportController extends BaseController  {

    @Resource
    private DataReportService dataReportService;

    @PostMapping("/report")
    @ApiOperation("获取报表数据")
    public BaseResponse<CommonPageInfoDTO<ReportDataInfoDTO>> report(HttpServletRequest request, @RequestBody @Valid DataReportRequestDTO requestBody) {
        String clientId = (String) request.getAttribute("clientId");
        return BaseController.success(dataReportService.report(clientId, requestBody));
    }
}
