package com.afanticar.afantiopenapi.model.dto;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author hejincai
 * @since 2025/4/23 16:39
 **/
@Data
@ApiModel("分页信息")
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class PageInfoDTO {
    @ApiModelProperty("当前页")
    private Integer page;

    @ApiModelProperty("页面大小，即每页展示的数据量")
    private Integer size;

    @ApiModelProperty("总数量")
    private Integer total;

    @ApiModelProperty("总页数")
    private Integer totalPage;
}
