package com.afanticar.afantiopenapi.model.vo;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 统一分页查询VO
 * @author Chin
 * @date 2023/04/27 14:02
 **/
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("统一分页查询VO")
public class BasePageVO<T> {

    @ApiModelProperty("当前页码")
    private Integer current;

    @ApiModelProperty("每页大小")
    private Integer size;

    @ApiModelProperty("数据总量")
    private Integer total;

    @ApiModelProperty("总页数")
    private Integer pages;

    @ApiModelProperty("列表数据")
    private List<T> records;

    public static <T> BasePageVO<T> restPage(int current, int size, int total, int pages, List<T> records) {
        BasePageVO<T> result = new BasePageVO<T>(1, 30, 0, 1, Lists.newArrayList());
        result.setCurrent(current);
        result.setSize(size);
        result.setTotal(total);
        result.setPages(pages);
        result.setRecords(records);
        return result;
    }
}
