package com.afanticar.afantiopenapi.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author hejincai
 * @since 2025/4/23 16:49
 **/
@Data
@ApiModel("数据报表信息")
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class ReportDataInfoDTO {

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("统计日期，格式为：yyyy-MM-dd。例如2024-01-01")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate statisticsDay;

    @ApiModelProperty("平台类型 public-公共数据 douyin-抖音 kuaishou-快手xiaohongshu-小红书 shipinhao-视频号")
    private String platform;

    @ApiModelProperty("数据报表类型 author_info-主播信息 aweme_info-视频信息 live_info-直播member_info-门店信息note_info 笔记信息")
    private String dataType;

    @ApiModelProperty("文件地址")
    private String fileUrl;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime ctime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime mtime;
}
