package com.afanticar.afantiopenapi.model.entity;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2023/4/26/026
 */

import com.alibaba.fastjson.annotation.JSONType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;

import java.util.Date;

/**
 * 活动信息
 * @author Chin
 */
@Data
@TableName("activity_info")
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class ActivityInfo {

    /** 活动ID */
    @TableId
    private Integer activityId;
    //private Integer principalId;
    /** 活动名称 */
    private String activityName;
    /** 活动规则 */
    private String participationRules;
    /** 奖励规则 */
    private String rewardRules;
    /** When the data was modified */
    private Date modificationTime;
    /** When the data was created */
    private Date creationTime;

}
