## ClickHouse批量写入SDK
[TAPD文档](https://www.tapd.cn/37799108/markdown_wikis/show/#1137799108001002671)

### (一) 注意事项
#### 1. 不可使用yandex.clickhouse 相关yml 和驱动 .若有相关配置必须先移除
> dynamic-db-yandex-clickhouse-vault.yml  ==> ru.yandex.clickhouse.ClickHouseDriver

```xml
<dependency>
  <groupId>ru.yandex.clickhouse</groupId>
  <artifactId>clickhouse-jdbc</artifactId>
</dependency>
```

使用 dynamic-db-clickhouse-vault.yml

### 2. 包内已存在一些依赖.若有冲突需自行排除
>org.apache.commons commons-lang3 - 3.7

```xml
<dependency>
    <groupId>org.apache.commons</groupId>
    <artifactId>commons-lang3</artifactId>
    <version>3.7</version>
</dependency>
```
>com.clickhouse clickhouse-jdbc - 0.4.6

```xml
<dependency>
    <!-- please stop using ru.yandex.clickhouse as it's been deprecated -->
    <groupId>com.clickhouse</groupId>
    <artifactId>clickhouse-jdbc</artifactId>
    <version>0.4.6</version>
    <!-- use uber jar with all dependencies included, change classifier to http for smaller jar -->
    <classifier>all</classifier>
    <exclusions>
        <exclusion>
            <groupId>*</groupId>
            <artifactId>*</artifactId>
        </exclusion>
    </exclusions>
</dependency>
```
>com.baomidou mybatis-plus-boot-starter - 3.5.1

```xml
<dependency>
    <groupId>com.baomidou</groupId>
    <artifactId>mybatis-plus-boot-starter</artifactId>
    <version>3.5.1</version>
</dependency>
```

#### 3. 时间类型字段 设置 NULL 会写入 1970-01-01 08:00:00 (ClickHouse DateTime 的默认值)


### (二) 使用步骤

####1. 引入Maven包
```xml
<dependency>
  <groupId>com.afanticar</groupId>
  <artifactId>batching-ck</artifactId>
  <version>1.0.0</version>
</dependency>
```

#### 2. IXXService 改为继承 ICkBatchService
#### 3. XXServiceImpl 改为继承 CkBatchServiceImpl
#### 4. 引用实际Service 使用saveBatchRecordsByInput (List<T> records)