package com.afanticar.job;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

public class ParseExcelUtils {

    /**
     * 迁移定时任务(使用代码代替手工配置定时任务)
     */
    public static void main(String[] args) throws IOException, InvalidFormatException {
        // cmd-worker服务开发环境对应的域名(集群环境用内网)
        String host = "afanti-crawler-cmd-worker.java-ms";

        String xxlJobHost = "https://xxl-job.afanticar.net/jobinfo/add";

        // 读取excel文件(解析定时任务规则、接口地址)
        Workbook wb = new XSSFWorkbook(new File("/Users/zhangzhihuang/Downloads/cloud_job_202301101902.xlsx"));
        // 解析第一页
        Sheet sheet = wb.getSheetAt(0);

        // 获取该页的行数
        int lastRowNum = sheet.getLastRowNum();
        List<Task> taskList = new ArrayList<>();

        // 遍历list(数值类型的值先不设置)
        for (int i = 1; i <= lastRowNum; i++) {
            Row row = sheet.getRow(i);
            Task task = new Task();
            task.setId(row.getCell(0).getNumericCellValue() + "");

            task.setApplication(row.getCell(1).getStringCellValue());
            task.setType(row.getCell(2).getStringCellValue()); // xxl-job-admin对应的类型是CORN
            task.setUri(row.getCell(3).getStringCellValue());
            task.setValue(row.getCell(4).getStringCellValue());

            // 这个单元格有可能空
            Cell c5 = row.getCell(5);
            if (c5 != null) {
                task.setStart_time(c5.getNumericCellValue() + "");
            }
            task.setState(row.getCell(6).getNumericCellValue() + "");
            task.setCtime(row.getCell(7).getNumericCellValue() + "");
            task.setMtime(row.getCell(8).getNumericCellValue() + "");
            task.setCreator(row.getCell(9).getStringCellValue());
            task.setModifier(row.getCell(10).getStringCellValue());
            task.setRemark(row.getCell(11).getStringCellValue());
            task.setIs_deleted(row.getCell(12).getNumericCellValue() + "");
            taskList.add(task);
        }

        // 倒序处理
        Collections.reverse(taskList);
        taskList.forEach(task -> {
            // 判断返回结果
            Map<String, Object> form = new HashMap<>();
            form.put("jobGroup", 2);
            form.put("jobDesc", "cmd-worker(" + task.getRemark() + ")");
            form.put("author", task.getCreator());
            form.put("scheduleType", task.getType().toUpperCase(Locale.ENGLISH));
            form.put("scheduleConf", task.getValue());
            form.put("cronGen_display", task.getValue());
            form.put("schedule_conf_CRON", task.getValue());
            form.put("glueType", "BEAN");
            form.put("executorHandler", "url");
            form.put("executorParam", "http://" + host + task.getUri());
            form.put("executorRouteStrategy", "ROUND");
            form.put("misfireStrategy", "DO_NOTHING");
            form.put("executorBlockStrategy", "SERIAL_EXECUTION");
            form.put("executorTimeout", 0);
            form.put("executorFailRetryCount", 5);
            form.put("glueRemark", "GLUE代码初始化");

            // 构建form表单并请求
            HttpRequest post = HttpRequest.post(xxlJobHost).header("cookie",
                "XXL_JOB_LOGIN_IDENTITY=7b226964223a312c22757365726e616d65223a2261646d696e222c2270617373776f7264223a226336333132616561393864386338356663633463383434363230393338653365222c22726f6c65223a312c227065726d697373696f6e223a6e756c6c7d; _oauth2_proxy=X29hdXRoMl9wcm94eS03NzE0YzFlZjRkOTIwZWY5YmRmMzFhNmZmOWZhYzkwZC54MFdDRFJoWURoM0doQk82UERXT01R|1674002495|YUtWToTp-MKn2AS8Plg0CbS3iwf_YGnMIWA7Konx6t0=")
                .form(form);

            HttpResponse execute = post.execute();

            // 校验结果
            int status = execute.getStatus();
            if (status != 200) {
                System.out.println(task + execute.body());
            }
        });
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Task {
        private String id;
        private String application; // 应用名称
        private String type; // 定时任务类型
        private String uri; // 接口
        private String value; // corn表达式
        private String start_time; // 开始时间
        private String state; // ? 未知
        private String ctime; // 创建时间
        private String mtime; // 修改时间
        private String creator; // 创建人
        private String modifier; // 修改人
        private String remark; // 备注
        private String is_deleted; // 是否删除
    }
}
